set sql_safe_updates=0;

-- Appointment

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    enq.code as ENQ_CODE,
    T1.appointeeName AS PRINT_NAME,
    T1.appointeeEmailId AS EMAIL_ID,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', 1)) AS MOBILE_CODE,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', - 1)) AS MOBILE_NO,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS FIRST_NAME,
	T2.academyName AS ACADEMY_NAME,
    T2.locationName AS LOCATION_NAME,
    T2.displayName AS ACADEMY_NAME_LOCATION,
    (Case 
    when T2.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T2.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T2.logoUrl)end) as LOGO_URL,
    (Case when T2.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T2.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment T1
        LEFT JOIN
    academy_location T2 ON T2.id = T1.academyLocationId
   		LEFT JOIN
    organizations org on org.id = 1
		LEFT JOIN
    enquiry enq on enq.id = T1.enquiryId
WHERE
    T1.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FIRST_NAME",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "PERSON_TO_MEET",
            "resultKey": "PERSON_TO_MEET",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "appointeeName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "code",
            "resultKey": "ENQ_CODE",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;
    
UPDATE `msg_template_config` SET `templateDataProviderId`=NULL WHERE `code`='Appointment';


-- Msg Template
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications'); 

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Buzz Appointment',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Buzz Appointment',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','YOUR APPOINTMENT HAS BEEN SCHEDULED','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
  <tr>
			<td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;HEADER_URL&quot;]"/></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$recipientData[&quot;ENQ_CODE&quot;]</strong></span></span></p>
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for making an appointment to come and see us. Your Appointment has been Booked for <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with $recipientData[&quot;PERSON_TO_MEET&quot;].</span></span></p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please be sure to bring along your ID document and a copy of your latest school results.
We look forward to seeing you!</span></span></p><br>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,</span></span> <br> $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</p> 
		<img align="right" height="80" width="100" src="$recipientData[&quot;LOGO_URL&quot;]" />
			</td>
		</tr>
        <tr>
			<td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','YOUR APPOINTMENT HAS BEEN SCHEDULED','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
  <tr>
			<td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;HEADER_URL&quot;]"/></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$recipientData[&quot;ENQ_CODE&quot;]</strong></span></span></p>
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for making an appointment to come and see us. Your Appointment has been Booked for <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with $recipientData[&quot;PERSON_TO_MEET&quot;].</span></span></p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please be sure to bring along your ID document and a copy of your latest school results.
We look forward to seeing you!</span></span></p><br>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,</span></span> <br> $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</p> 
		<img align="right" height="80" width="100" src="$recipientData[&quot;LOGO_URL&quot;]" />
			</td>
		</tr>
        <tr>
			<td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');



set sql_safe_updates=1;

